//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Text;
using System.Diagnostics;
using System.Runtime.Remoting.Lifetime;

namespace CLRUnleashed.Remoting
{
	/// <summary>
	/// Summary description for TimeObject.
	/// </summary>
	public class TimeObject : MarshalByRefObject
	{
		public TimeObject()
		{
			Console.WriteLine("TimeObject zosta aktywowany {0}", DateTime.Now);
			dateCount = 0;
			timeCount = 0;
		}
		public string Time
		{
			get
			{
				timeCount++;
				return DateTime.Now.ToLongTimeString();
			}
		}
		public string Date
		{
			get
			{
				dateCount++;
				return DateTime.Now.ToLongDateString();
			}
		}
		public int DateCount
		{
			get
			{
				return dateCount;
			}
		}
		public int TimeCount
		{
			get
			{
				return timeCount;
			}
		}
		// Naley usun znaki komentarza dla tej metody,
		// aby cyklycia obiektu by nieskoczony.
//		public override object InitializeLifetimeService()
//		{
//			 return null;
//		}
		private int dateCount;
		private int timeCount;
	}
}
